/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators;

import BryceImages.Rendering.ColorCalculator;
import BryceMath.functions.Interpolator;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Random;

public class ccPerlinNoise
extends ColorCalculator {
    final int size = 100;
    double[][][] noise = new double[100][100][100];
    Interpolator interp = new Interpolator(1);
    int time;
    double persistence = 0.25;
    int Number_Of_Octaves = 1;

    public ccPerlinNoise(Dimension dim, int time, double persistence, int octaves) {
        super(dim);
        this.antiAliasing = 3;
        this.generateNoise();
        this.time = time;
        this.persistence = persistence;
        this.Number_Of_Octaves = octaves;
    }

    public ccPerlinNoise(int width, int height, int time, double persistence, int octaves) {
        super(width, height);
        this.antiAliasing = 3;
        this.generateNoise();
        this.time = time;
        this.persistence = persistence;
        this.Number_Of_Octaves = octaves;
    }

    private void generateNoise() {
        Random random = new Random();
        random.setSeed(0L);
        int a = 0;
        while (a < 100) {
            int b = 0;
            while (b < 100) {
                int c = 0;
                while (c < 100) {
                    this.noise[a][b][c] = random.nextDouble();
                    ++c;
                }
                ++b;
            }
            ++a;
        }
    }

    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public Color getColor(double x, double y) {
        return ccPerlinNoise.Color_hsv(0.0, 0.0, 100.0 * this.getVal(x, y));
    }

    public double getVal(double x, double y) {
        x = Math.abs(x);
        y = Math.abs(y);
        double scale = 100.0 / (double)this.room_width;
        double val = this.PerlinNoise_2D(x * scale, y * scale);
        return val;
    }

    public double grain(double val) {
        val *= 20.0;
        val -= (double)((int)val);
        return val;
    }

    public double exp(double val) {
        double CloudCover = 0.5;
        double CloudSharpness = 0.01;
        double c = val - CloudCover;
        if (c < 0.0) {
            c = 0.0;
        }
        double CloudDensity = 1.0 - Math.pow(CloudSharpness, c);
        return CloudDensity;
    }

    double noise(int x, int y) {
        return this.noise(x, y, this.time);
    }

    double noise(int x, int y, int z) {
        int a = x % 100;
        int b = y % 100;
        int c = z % 100;
        if (a < 0) {
            a += 100;
        }
        if (b < 0) {
            b += 100;
        }
        if (c < 0) {
            c += 100;
        }
        return this.noise[a][b][c];
    }

    double SmoothedNoise(int x, int y) {
        double corners = (this.noise(x - 1, y - 1) + this.noise(x + 1, y - 1) + this.noise(x - 1, y + 1) + this.noise(x + 1, y + 1)) / 16.0;
        double sides = (this.noise(x - 1, y) + this.noise(x + 1, y) + this.noise(x, y - 1) + this.noise(x, y + 1)) / 8.0;
        double center = this.noise(x, y) / 4.0;
        return corners + sides + center;
    }

    double InterpolatedNoise_1(double x, double y) {
        int integer_X = (int)x;
        double fractional_X = x - (double)integer_X;
        int integer_Y = (int)y;
        double fractional_Y = y - (double)integer_Y;
        double v1 = this.SmoothedNoise(integer_X, integer_Y);
        double v2 = this.SmoothedNoise(integer_X + 1, integer_Y);
        double v3 = this.SmoothedNoise(integer_X, integer_Y + 1);
        double v4 = this.SmoothedNoise(integer_X + 1, integer_Y + 1);
        double i1 = this.Interpolate(v1, v2, fractional_X);
        double i2 = this.Interpolate(v3, v4, fractional_X);
        return this.Interpolate(i1, i2, fractional_Y);
    }

    double Interpolate(double val1, double val2, double percent2) {
        double weight2 = this.interp.eval(percent2);
        double weight1 = 1.0 - weight2;
        return val1 * weight1 + val2 * weight2;
    }

    double PerlinNoise_2D(double x, double y) {
        double total = 0.0;
        double p = this.persistence;
        int n = this.Number_Of_Octaves;
        double amplitude = 1.0;
        int i = 0;
        while (i < n) {
            int frequency = (int)Math.pow(2.0, i);
            amplitude = Math.pow(p, i + 1);
            total += this.InterpolatedNoise_1(x * (double)frequency, y * (double)frequency) * amplitude;
            ++i;
        }
        double scale = p * (1.0 - Math.pow(p, n)) / (1.0 - p);
        scale = 1.0 / scale;
        return total * scale;
    }
}

